/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;

public class BitmapUtils {
    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }

    public static Bitmap resizeImage(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap resizeImageAndRotation(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f, -1.0f);
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    private static byte[] getBinaryzationBytes(Bitmap bitmap) {
        return BitmapUtils.getBinaryzationBytes(bitmap, 128, false);
    }

    private static byte[] getBinaryzationBytes(Bitmap bitmap, boolean reverse) {
        return BitmapUtils.getBinaryzationBytes(bitmap, 128, reverse);
    }

    private static byte[] getBinaryzationBytes(Bitmap bitmap, int threshold, boolean reverse) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] data = new byte[width * height];
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int color = pixels[i * width + j];
                int gray = (int)(0.299 * (double)((color & 0xFF0000) >> 16) + 0.587 * (double)((color & 0xFF00) >> 8) + 0.114 * (double)(color & 0xFF));
                byte y = (byte)(reverse ? 1 : 0);
                byte n = (byte)(!reverse ? 1 : 0);
                data[i * width + j] = gray < threshold ? y : n;
            }
        }
        return data;
    }

    public static byte[] getCompressedBinaryzationBytes(Bitmap bitmap) {
        return BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, false);
    }

    public static byte[] getCompressedBinaryzationBytes(Bitmap bitmap, boolean reverse) {
        return BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, reverse);
    }

    public static byte[] getCompressedBinaryzationBytes(Bitmap bitmap, int threshold, boolean reverse) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int lineBytes = (width - 1) / 8 + 1;
        byte[] data = new byte[lineBytes * height];
        byte[] imageBytes = BitmapUtils.getBinaryzationBytes(bitmap, threshold, reverse);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < lineBytes; ++j) {
                byte unit = 0;
                for (int k = 0; k < 8; ++k) {
                    if ((j << 3) + k >= width) continue;
                    byte pixel = imageBytes[i * width + (j << 3) + k];
                    unit = (byte)(unit | (pixel & 1) << 7 - k);
                }
                data[i * lineBytes + j] = unit;
            }
        }
        return data;
    }

    public static Bitmap threshold(Bitmap img, boolean shake) {
        int height = img.getHeight();
        int width = img.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)img.getConfig());
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(img, 0.0f, 0.0f, paint);
        img = bmpGrayscale;
        width = img.getWidth();
        height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int red;
                int grey = pixels[width * i + j];
                gray[width * i + j] = red = (grey & 0xFF0000) >> 16;
            }
        }
        int e = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int g = gray[width * i + j];
                if (g >= 128) {
                    pixels[width * i + j] = -1;
                    e = g - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    e = g - 0;
                }
                if (!shake) continue;
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    gray[n] = gray[n] + 7 * e / 16;
                    int n2 = width * (i + 1) + j;
                    gray[n2] = gray[n2] + 5 * e / 16;
                    int n3 = width * (i + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 16;
                    if (j <= 0) continue;
                    int n4 = width * (i + 1) + j - 1;
                    gray[n4] = gray[n4] + 3 * e / 16;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    gray[n] = gray[n] + 5 * e / 16;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                gray[n] = gray[n] + 7 * e / 16;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)img.getConfig());
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    public static Bitmap filter(Bitmap src) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getPixels(inPixels, 0, width, 0, 0, width, height);
        int index = 0;
        double redSum = 0.0;
        double greenSum = 0.0;
        double blueSum = 0.0;
        double total = height * width;
        for (int row = 0; row < height; ++row) {
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int col = 0; col < width; ++col) {
                index = row * width + col;
                ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                tg = inPixels[index] >> 8 & 0xFF;
                tb = inPixels[index] & 0xFF;
                redSum += (double)tr;
                greenSum += (double)tg;
                blueSum += (double)tb;
            }
        }
        int means = (int)(redSum / total);
        System.out.println(" threshold average value = " + means);
        for (int row = 0; row < height; ++row) {
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int col = 0; col < width; ++col) {
                index = row * width + col;
                ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                tg = inPixels[index] >> 8 & 0xFF;
                tb = inPixels[index] & 0xFF;
                if (tr >= means) {
                    tb = 255;
                    tg = 255;
                    tr = 255;
                } else {
                    tb = 0;
                    tg = 0;
                    tr = 0;
                }
                outPixels[index] = ta << 24 | tr << 16 | tg << 8 | tb;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)src.getConfig());
        mBitmap.setPixels(outPixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }
}

